/*
 * Decompiled with CFR 0.152.
 */
package Grapher.geom;

import Grapher.util.PuDomain;
import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgImpSurf
extends PgElementSet {
    public static final int TYPE_IMPSURF = 4;
    public static final int TYPE_IMPCYL = 7;
    public static final int TYPE_IMPSPH = 8;
    protected PuFunction m_func2;
    protected PuDomain m_domain;
    protected int coords;
    protected int[][][] xedge;
    protected int[][] yedge;
    protected int[] zedge;
    protected double[][][] xpoint;
    protected double[][] ypoint;
    protected double[] zpoint;
    protected double[][] xval;
    protected double[] yval;
    protected double zval;
    protected int[] discr;
    protected boolean m_bHasVf = false;
    static final int[][] triTable = new int[][]{{-1}, {3, 0, 8, -1}, {0, 1, 9, -1}, {3, 1, 9, 8, -1}, {1, 2, 10, -1}, {3, 2, 10, 1, 0, 8, -1}, {0, 2, 10, 9, -1}, {3, 2, 10, 9, 8, -1}, {2, 3, 11, -1}, {11, 2, 0, 8, -1}, {2, 1, 9, 0, 3, 11, -1}, {11, 2, 1, 9, 8, -1}, {10, 1, 3, 11, -1}, {11, 10, 1, 0, 8, -1}, {10, 9, 0, 3, 11, -1}, {11, 10, 9, 8, -1}, {4, 7, 8, -1}, {0, 4, 7, 3, -1}, {0, 1, 9, 4, 7, 8, -1}, {1, 9, 4, 7, 3, -1}, {4, 7, 8, -1, 1, 2, 10, -1}, {2, 10, 1, 0, 4, 7, 3, -1}, {0, 2, 10, 9, 4, 7, 8, -1}, {2, 10, 9, 4, 7, 3, -1}, {4, 7, 11, 2, 3, 8, -1}, {2, 0, 4, 7, 11, -1}, {0, 3, 8, -1, 2, 1, 9, 4, 7, 11, -1}, {2, 1, 9, 4, 7, 11, -1}, {4, 7, 11, 10, 1, 3, 8, -1}, {10, 1, 0, 4, 7, 11, -1}, {0, 3, 8, -1, 10, 9, 4, 7, 11, -1}, {10, 9, 4, 7, 11, -1}, {5, 4, 9, -1}, {3, 0, 9, 5, 4, 8, -1}, {5, 4, 0, 1, -1}, {3, 1, 5, 4, 8, -1}, {1, 2, 10, 5, 4, 9, -1}, {3, 2, 10, 5, 4, 8, -1, 1, 0, 9, -1}, {5, 4, 0, 2, 10, -1}, {3, 2, 10, 5, 4, 8, -1}, {2, 3, 11, -1, 5, 4, 9, -1}, {11, 2, 0, 9, 5, 4, 8, -1}, {2, 1, 5, 4, 0, 3, 11, -1}, {11, 2, 1, 5, 4, 8, -1}, {10, 5, 4, 9, 1, 3, 11, -1}, {11, 10, 5, 4, 8, -1, 1, 0, 9, -1}, {10, 5, 4, 0, 3, 11, -1}, {11, 10, 5, 4, 8, -1}, {9, 5, 7, 8, -1}, {0, 9, 5, 7, 3, -1}, {0, 1, 5, 7, 8, -1}, {1, 5, 7, 3, -1}, {9, 1, 2, 10, 5, 7, 8, -1}, {2, 10, 5, 7, 3, -1, 1, 0, 9, -1}, {0, 2, 10, 5, 7, 8, -1}, {2, 10, 5, 7, 3, -1}, {9, 5, 7, 11, 2, 3, 8, -1}, {2, 0, 9, 5, 7, 11, -1}, {0, 3, 8, -1, 2, 1, 5, 7, 11, -1}, {2, 1, 5, 7, 11, -1}, {9, 1, 3, 8, -1, 10, 5, 7, 11, -1}, {10, 5, 7, 11, -1, 1, 0, 9, -1}, {0, 3, 8, -1, 10, 5, 7, 11, -1}, {10, 5, 7, 11, -1}, {6, 5, 10, -1}, {3, 0, 8, -1, 6, 5, 10, -1}, {0, 1, 10, 6, 5, 9, -1}, {3, 1, 10, 6, 5, 9, 8, -1}, {2, 6, 5, 1, -1}, {3, 2, 6, 5, 1, 0, 8, -1}, {0, 2, 6, 5, 9, -1}, {3, 2, 6, 5, 9, 8, -1}, {6, 5, 10, 2, 3, 11, -1}, {11, 6, 5, 10, 2, 0, 8, -1}, {6, 5, 9, 0, 3, 11, -1, 2, 1, 10, -1}, {11, 6, 5, 9, 8, -1, 2, 1, 10, -1}, {6, 5, 1, 3, 11, -1}, {11, 6, 5, 1, 0, 8, -1}, {6, 5, 9, 0, 3, 11, -1}, {11, 6, 5, 9, 8, -1}, {4, 5, 10, 6, 7, 8, -1}, {0, 4, 5, 10, 6, 7, 3, -1}, {0, 1, 10, 6, 7, 8, -1, 4, 5, 9, -1}, {1, 10, 6, 7, 3, -1, 4, 5, 9, -1}, {4, 5, 1, 2, 6, 7, 8, -1}, {2, 6, 7, 3, -1, 0, 4, 5, 1, -1}, {0, 2, 6, 7, 8, -1, 4, 5, 9, -1}, {2, 6, 7, 3, -1, 4, 5, 9, -1}, {4, 5, 10, 2, 3, 8, -1, 6, 7, 11, -1}, {6, 7, 11, -1, 2, 0, 4, 5, 10, -1}, {0, 3, 8, -1, 6, 7, 11, -1, 4, 5, 9, -1, 2, 1, 10, -1}, {6, 7, 11, -1, 4, 5, 9, -1, 2, 1, 10, -1}, {4, 5, 1, 3, 8, -1, 6, 7, 11, -1}, {6, 7, 11, -1, 0, 4, 5, 1, -1}, {0, 3, 8, -1, 6, 7, 11, -1, 4, 5, 9, -1}, {6, 7, 11, -1, 4, 5, 9, -1}, {10, 6, 4, 9, -1}, {3, 0, 9, 10, 6, 4, 8, -1}, {6, 4, 0, 1, 10, -1}, {3, 1, 10, 6, 4, 8, -1}, {1, 2, 6, 4, 9, -1}, {3, 2, 6, 4, 8, -1, 1, 0, 9, -1}, {2, 6, 4, 0, -1}, {3, 2, 6, 4, 8, -1}, {6, 4, 9, 10, 2, 3, 11, -1}, {11, 6, 4, 8, -1, 10, 2, 0, 9, -1}, {6, 4, 0, 3, 11, -1, 2, 1, 10, -1}, {11, 6, 4, 8, -1, 2, 1, 10, -1}, {6, 4, 9, 1, 3, 11, -1}, {11, 6, 4, 8, -1, 1, 0, 9, -1}, {6, 4, 0, 3, 11, -1}, {11, 6, 4, 8, -1}, {9, 10, 6, 7, 8, -1}, {0, 9, 10, 6, 7, 3, -1}, {0, 1, 10, 6, 7, 8, -1}, {1, 10, 6, 7, 3, -1}, {9, 1, 2, 6, 7, 8, -1}, {2, 6, 7, 3, -1, 1, 0, 9, -1}, {0, 2, 6, 7, 8, -1}, {2, 6, 7, 3, -1}, {9, 10, 2, 3, 8, -1, 6, 7, 11, -1}, {6, 7, 11, -1, 10, 2, 0, 9, -1}, {0, 3, 8, -1, 6, 7, 11, -1, 2, 1, 10, -1}, {6, 7, 11, -1, 2, 1, 10, -1}, {9, 1, 3, 8, -1, 6, 7, 11, -1}, {6, 7, 11, -1, 1, 0, 9, -1}, {0, 3, 8, -1, 6, 7, 11, -1}, {6, 7, 11, -1}, {7, 6, 11, -1}, {7, 6, 11, 3, 0, 8, -1}, {7, 6, 11, -1, 0, 1, 9, -1}, {7, 6, 11, 3, 1, 9, 8, -1}, {7, 6, 10, 1, 2, 11, -1}, {7, 6, 10, 1, 0, 8, -1, 3, 2, 11, -1}, {7, 6, 10, 9, 0, 2, 11, -1}, {7, 6, 10, 9, 8, -1, 3, 2, 11, -1}, {7, 6, 2, 3, -1}, {7, 6, 2, 0, 8, -1}, {7, 6, 2, 1, 9, 0, 3, -1}, {7, 6, 2, 1, 9, 8, -1}, {7, 6, 10, 1, 3, -1}, {7, 6, 10, 1, 0, 8, -1}, {7, 6, 10, 9, 0, 3, -1}, {7, 6, 10, 9, 8, -1}, {4, 6, 11, 8, -1}, {3, 0, 4, 6, 11, -1}, {0, 1, 9, 4, 6, 11, 8, -1}, {3, 1, 9, 4, 6, 11, -1}, {4, 6, 10, 1, 2, 11, 8, -1}, {3, 2, 11, -1, 1, 0, 4, 6, 10, -1}, {0, 2, 11, 8, -1, 4, 6, 10, 9, -1}, {3, 2, 11, -1, 4, 6, 10, 9, -1}, {4, 6, 2, 3, 8, -1}, {4, 6, 2, 0, -1}, {0, 3, 8, -1, 4, 6, 2, 1, 9, -1}, {4, 6, 2, 1, 9, -1}, {4, 6, 10, 1, 3, 8, -1}, {1, 0, 4, 6, 10, -1}, {0, 3, 8, -1, 4, 6, 10, 9, -1}, {4, 6, 10, 9, -1}, {7, 4, 9, 5, 6, 11, -1}, {7, 4, 8, -1, 3, 0, 9, 5, 6, 11, -1}, {7, 4, 0, 1, 5, 6, 11, -1}, {7, 4, 8, -1, 3, 1, 5, 6, 11, -1}, {7, 4, 9, 1, 2, 11, -1, 5, 6, 10, -1}, {7, 4, 8, -1, 3, 2, 11, -1, 1, 0, 9, -1, 5, 6, 10, -1}, {7, 4, 0, 2, 11, -1, 5, 6, 10, -1}, {7, 4, 8, -1, 3, 2, 11, -1, 5, 6, 10, -1}, {7, 4, 9, 5, 6, 2, 3, -1}, {7, 4, 8, -1, 5, 6, 2, 0, 9, -1}, {7, 4, 0, 3, -1, 5, 6, 2, 1, -1}, {7, 4, 8, -1, 5, 6, 2, 1, -1}, {7, 4, 9, 1, 3, -1, 5, 6, 10, -1}, {7, 4, 8, -1, 1, 0, 9, -1, 5, 6, 10, -1}, {7, 4, 0, 3, -1, 5, 6, 10, -1}, {7, 4, 8, -1, 5, 6, 10, -1}, {9, 5, 6, 11, 8, -1}, {3, 0, 9, 5, 6, 11, -1}, {0, 1, 5, 6, 11, 8, -1}, {3, 1, 5, 6, 11, -1}, {9, 1, 2, 11, 8, -1, 5, 6, 10, -1}, {3, 2, 11, -1, 1, 0, 9, -1, 5, 6, 10, -1}, {0, 2, 11, 8, -1, 5, 6, 10, -1}, {3, 2, 11, -1, 5, 6, 10, -1}, {9, 5, 6, 2, 3, 8, -1}, {5, 6, 2, 0, 9, -1}, {0, 3, 8, -1, 5, 6, 2, 1, -1}, {5, 6, 2, 1, -1}, {9, 1, 3, 8, -1, 5, 6, 10, -1}, {1, 0, 9, -1, 5, 6, 10, -1}, {0, 3, 8, -1, 5, 6, 10, -1}, {5, 6, 10, -1}, {7, 5, 10, 11, -1}, {7, 5, 10, 11, 3, 0, 8, -1}, {7, 5, 9, 0, 1, 10, 11, -1}, {7, 5, 9, 8, -1, 3, 1, 10, 11, -1}, {7, 5, 1, 2, 11, -1}, {7, 5, 1, 0, 8, -1, 3, 2, 11, -1}, {7, 5, 9, 0, 2, 11, -1}, {7, 5, 9, 8, -1, 3, 2, 11, -1}, {7, 5, 10, 2, 3, -1}, {7, 5, 10, 2, 0, 8, -1}, {7, 5, 9, 0, 3, -1, 2, 1, 10, -1}, {7, 5, 9, 8, -1, 2, 1, 10, -1}, {7, 5, 1, 3, -1}, {7, 5, 1, 0, 8, -1}, {7, 5, 9, 0, 3, -1}, {7, 5, 9, 8, -1}, {4, 5, 10, 11, 8, -1}, {3, 0, 4, 5, 10, 11, -1}, {0, 1, 10, 11, 8, -1, 4, 5, 9, -1}, {3, 1, 10, 11, -1, 4, 5, 9, -1}, {4, 5, 1, 2, 11, 8, -1}, {3, 2, 11, -1, 0, 4, 5, 1, -1}, {0, 2, 11, 8, -1, 4, 5, 9, -1}, {3, 2, 11, -1, 4, 5, 9, -1}, {4, 5, 10, 2, 3, 8, -1}, {2, 0, 4, 5, 10, -1}, {0, 3, 8, -1, 4, 5, 9, -1, 2, 1, 10, -1}, {4, 5, 9, -1, 2, 1, 10, -1}, {4, 5, 1, 3, 8, -1}, {0, 4, 5, 1, -1}, {0, 3, 8, -1, 4, 5, 9, -1}, {4, 5, 9, -1}, {7, 4, 9, 10, 11, -1}, {7, 4, 8, -1, 3, 0, 9, 10, 11, -1}, {7, 4, 0, 1, 10, 11, -1}, {7, 4, 8, -1, 3, 1, 10, 11, -1}, {7, 4, 9, 1, 2, 11, -1}, {7, 4, 8, -1, 3, 2, 11, -1, 1, 0, 9, -1}, {7, 4, 0, 2, 11, -1}, {7, 4, 8, -1, 3, 2, 11, -1}, {7, 4, 9, 10, 2, 3, -1}, {7, 4, 8, -1, 10, 2, 0, 9, -1}, {7, 4, 0, 3, -1, 2, 1, 10, -1}, {7, 4, 8, -1, 2, 1, 10, -1}, {7, 4, 9, 1, 3, -1}, {7, 4, 8, -1, 1, 0, 9, -1}, {7, 4, 0, 3, -1}, {7, 4, 8, -1}, {9, 10, 11, 8, -1}, {3, 0, 9, 10, 11, -1}, {0, 1, 10, 11, 8, -1}, {3, 1, 10, 11, -1}, {9, 1, 2, 11, 8, -1}, {3, 2, 11, -1, 1, 0, 9, -1}, {0, 2, 11, 8, -1}, {3, 2, 11, -1}, {9, 10, 2, 3, 8, -1}, {10, 2, 0, 9, -1}, {0, 3, 8, -1, 2, 1, 10, -1}, {2, 1, 10, -1}, {9, 1, 3, 8, -1}, {1, 0, 9, -1}, {0, 3, 8, -1}, {-1}};
    static /* synthetic */ Class class$Grapher$geom$PgImpSurf;

    public PgImpSurf(String string, int n) {
        super(3);
        if (((Object)((Object)this)).getClass() == (class$Grapher$geom$PgImpSurf == null ? (class$Grapher$geom$PgImpSurf = PgImpSurf.class$("Grapher.geom.PgImpSurf")) : class$Grapher$geom$PgImpSurf)) {
            this.init(string, n);
        }
    }

    public void init(String string, int n) {
        super.init();
        this.setName(string);
        this.coords = n;
        this.m_func2 = new PuFunction(3, 1);
        this.m_func2.setName("Functions");
        this.m_domain = new PuDomain();
        if (this.coords == 4) {
            this.m_func2.setVariables(new String[]{"x", "y", "z"});
            this.m_domain.setVars(new String[]{"x", "y", "z"});
        } else if (this.coords == 7) {
            this.m_func2.setVariables(new String[]{"r", "t", "z"});
            this.m_domain.setVars(new String[]{"r", "t", "z"});
            this.m_domain.setDefVals(new double[]{0.0, 5.0, 0.0, Math.PI * 2, -5.0, 5.0});
        } else if (this.coords == 8) {
            this.m_func2.setVariables(new String[]{"r", "t", "p"});
            this.m_domain.setVars(new String[]{"r", "t", "p"});
            this.m_domain.setDefVals(new double[]{0.0, 5.0, 0.0, Math.PI * 2, 0.0, Math.PI});
        }
        this.m_func2.setExpression(0, "0");
        this.m_func2.setParent((PsUpdateIf)this);
        this.m_domain.setDefDiscr(new int[]{14});
        this.m_domain.setNumDiscr(1);
        this.m_domain.setAllowSlices(true);
        this.m_domain.init();
        this.m_domain.setParent((PsUpdateIf)this);
        this.assureElementColors();
        this.showElementColors(true);
        this.showVertices(false);
    }

    public void start() {
    }

    public boolean update(Object object) {
        if (object == this) {
            this.computeImpSurf();
            return super.update((Object)this);
        }
        if (object == this.m_domain) {
            this.update((Object)this);
        } else if (object == this.m_func2) {
            this.update((Object)this);
        }
        return true;
    }

    public void computeImpSurf() {
        super.init();
        this.Polygonize();
        this.assureElementColors();
        this.makeElementNormals();
        this.makeElementColorsFromXYZ();
        this.showElementColors(true);
    }

    public void Polygonize() {
        this.discr = new int[3];
        this.discr[0] = this.m_domain.getDiscr(0);
        this.discr[1] = this.discr[0];
        this.discr[2] = this.discr[0];
        double d = this.m_domain.getMin(0);
        double d2 = this.m_domain.getMin(1);
        double d3 = this.m_domain.getMin(2);
        double d4 = (this.m_domain.getMax(0) - d) / (double)this.discr[0];
        double d5 = (this.m_domain.getMax(1) - d2) / (double)this.discr[1];
        double d6 = (this.m_domain.getMax(2) - d3) / (double)this.discr[2];
        double d7 = 0.0;
        if (this.m_domain.isSliced(0)) {
            d4 = 0.1;
            this.discr[0] = 1;
        }
        if (this.m_domain.isSliced(1)) {
            d5 = 0.1;
            this.discr[1] = 1;
        }
        if (this.m_domain.isSliced(2)) {
            d6 = 0.1;
            this.discr[2] = 1;
        }
        this.xedge = new int[this.discr[1] + 1][this.discr[2] + 1][2];
        this.yedge = new int[this.discr[2] + 1][2];
        this.zedge = new int[2];
        this.xpoint = new double[this.discr[1] + 1][this.discr[2] + 1][3];
        this.ypoint = new double[this.discr[2] + 1][3];
        this.zpoint = new double[3];
        this.xval = new double[this.discr[1] + 1][this.discr[2] + 1];
        this.yval = new double[this.discr[2] + 1];
        double[][] dArray = new double[8][3];
        double[] dArray2 = new double[8];
        this.initXstorage(this.discr, d, d2, d3, d4, d5, d6, d7);
        double d8 = d;
        int n = 0;
        while (n < this.discr[0]) {
            this.initYstorage(this.discr, d8, d2, d3, d4, d5, d6, d7);
            double d9 = d2;
            int n2 = 0;
            while (n2 < this.discr[1]) {
                this.initZstorage(this.discr, d8, d9, d3, d4, d5, d6, d7);
                double d10 = d3;
                int n3 = 0;
                while (n3 < this.discr[2]) {
                    dArray[6] = new double[]{d8 + d4, d9 + d5, d10 + d6};
                    dArray2[6] = this.m_func2.eval(0, dArray[6]);
                    this.Polygoner(dArray[6], dArray2[6], n, n2, n3);
                    d10 += d6;
                    ++n3;
                }
                d9 += d5;
                ++n2;
            }
            d8 += d4;
            ++n;
        }
    }

    public int Polygoner(double[] dArray, double d, int n, int n2, int n3) {
        double d2 = 0.0;
        int[] nArray = new int[12];
        int n4 = 0;
        if (d < d2) {
            n4 |= 0x40;
        }
        if (d < d2 != this.zval < d2) {
            nArray[10] = this.addVertex(new PdVector(this.VertexInterp(d2, this.zpoint, dArray, this.zval, d)));
            if ((n4 & 0x40) == 0) {
                n4 |= 4;
            }
        } else {
            nArray[10] = -1;
            if ((n4 & 0x40) != 0) {
                n4 |= 4;
            }
        }
        if (d < d2 != this.yval[n3] < d2) {
            nArray[5] = this.addVertex(new PdVector(this.VertexInterp(d2, this.ypoint[n3], dArray, this.yval[n3], d)));
            if ((n4 & 0x40) == 0) {
                n4 |= 0x20;
            }
        } else {
            nArray[5] = -1;
            if ((n4 & 0x40) != 0) {
                n4 |= 0x20;
            }
        }
        if (d < d2 != this.xval[n2][n3] < d2) {
            nArray[6] = this.addVertex(new PdVector(this.VertexInterp(d2, dArray, this.xpoint[n2][n3], d, this.xval[n2][n3])));
            if ((n4 & 0x40) == 0) {
                n4 |= 0x80;
            }
        } else {
            nArray[6] = -1;
            if ((n4 & 0x40) != 0) {
                n4 |= 0x80;
            }
        }
        nArray[0] = this.yedge[n3][0];
        nArray[1] = this.zedge[0];
        nArray[2] = this.zedge[1];
        nArray[3] = this.xedge[n2][n3][0];
        nArray[4] = this.yedge[n3 + 1][0];
        nArray[7] = this.xedge[n2][n3 + 1][0];
        nArray[8] = this.xedge[n2][n3][1];
        nArray[9] = this.yedge[n3][1];
        nArray[11] = this.xedge[n2 + 1][n3][1];
        if (nArray[1] != -1) {
            if ((n4 & 4) == 0) {
                n4 |= 2;
            }
        } else if ((n4 & 4) != 0) {
            n4 |= 2;
        }
        if (nArray[2] != -1) {
            if ((n4 & 4) == 0) {
                n4 |= 8;
            }
        } else if ((n4 & 4) != 0) {
            n4 |= 8;
        }
        if (nArray[0] != -1) {
            if ((n4 & 2) == 0) {
                n4 |= 1;
            }
        } else if ((n4 & 2) != 0) {
            n4 |= 1;
        }
        if (nArray[8] != -1) {
            if ((n4 & 1) == 0) {
                n4 |= 0x10;
            }
        } else if ((n4 & 1) != 0) {
            n4 |= 0x10;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < triTable[n4].length) {
            if (triTable[n4][n7] != -1) {
                ++n5;
            } else if (n5 > 0) {
                int[] nArray2 = new int[n5];
                boolean bl = false;
                int n8 = 0;
                while (n8 < n5) {
                    nArray2[n5 - n8 - 1] = nArray[triTable[n4][n8 + n6]];
                    if (nArray2[n5 - n8 - 1] == -1) {
                        bl = true;
                    }
                    ++n8;
                }
                if (!bl) {
                    this.addElement(new PiVector(nArray2));
                } else {
                    System.out.println("Badcube cubeindex: " + n4);
                    System.out.println("Location: " + n + "," + n2 + "," + n3);
                    int n9 = 0;
                    while (n9 < n5) {
                        System.out.println(triTable[n4][n9 + n6] + ": " + nArray2[n5 - n9 - 1]);
                        ++n9;
                    }
                }
                n5 = 0;
                n6 = n7 + 1;
            }
            ++n7;
        }
        this.xedge[n2][n3][0] = nArray[1];
        this.xedge[n2][n3][1] = nArray[9];
        this.yedge[n3][0] = nArray[2];
        this.yedge[n3][1] = nArray[10];
        this.zedge[0] = nArray[5];
        this.zedge[1] = nArray[6];
        this.xpoint[n2][n3] = dArray;
        this.xval[n2][n3] = d;
        this.ypoint[n3] = dArray;
        this.yval[n3] = d;
        this.zpoint = dArray;
        this.zval = d;
        if (n2 == this.discr[1] - 1) {
            this.xedge[n2 + 1][n3][1] = nArray[10];
        }
        if (n3 == this.discr[2] - 1) {
            this.xedge[n2][n3 + 1][0] = nArray[5];
            this.yedge[n3 + 1][0] = nArray[6];
        }
        return 1;
    }

    double[] VertexInterp(double d, double[] dArray, double[] dArray2, double d2, double d3) {
        double[] dArray3 = new double[3];
        if (Math.abs(d - d2) < 1.0E-5) {
            return this.convertToXYZ(dArray);
        }
        if (Math.abs(d - d3) < 1.0E-5) {
            return this.convertToXYZ(dArray2);
        }
        if (Math.abs(d2 - d3) < 1.0E-5) {
            return this.convertToXYZ(dArray);
        }
        double d4 = (d - d2) / (d3 - d2);
        dArray3[0] = dArray[0] + d4 * (dArray2[0] - dArray[0]);
        dArray3[1] = dArray[1] + d4 * (dArray2[1] - dArray[1]);
        dArray3[2] = dArray[2] + d4 * (dArray2[2] - dArray[2]);
        return this.convertToXYZ(dArray3);
    }

    void initXstorage(int[] nArray, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double[][] dArray = new double[8][3];
        double[] dArray2 = new double[8];
        double d8 = d;
        double d9 = d2;
        int n = 0;
        while (n < nArray[1] + 1) {
            d9 = d2 + d5 * (double)n;
            double d10 = d3;
            int n2 = 0;
            while (n2 < nArray[2] + 1) {
                d10 = d3 + d6 * (double)n2;
                dArray[0] = new double[]{d8, d9, d10};
                dArray[3] = new double[]{d8, d9 + d5, d10};
                dArray[4] = new double[]{d8, d9, d10 + d6};
                dArray[7] = new double[]{d8, d9 + d5, d10 + d6};
                dArray2[0] = this.m_func2.eval(0, dArray[0]);
                dArray2[3] = this.m_func2.eval(0, dArray[3]);
                dArray2[4] = this.m_func2.eval(0, dArray[4]);
                dArray2[7] = this.m_func2.eval(0, dArray[7]);
                this.xedge[n][n2][0] = dArray2[0] < d7 != dArray2[3] < d7 ? this.addVertex(new PdVector(this.VertexInterp(d7, dArray[3], dArray[0], dArray2[3], dArray2[0]))) : -1;
                this.xedge[n][n2][1] = dArray2[0] < d7 != dArray2[4] < d7 ? this.addVertex(new PdVector(this.VertexInterp(d7, dArray[0], dArray[4], dArray2[0], dArray2[4]))) : -1;
                this.xpoint[n][n2] = dArray[7];
                this.xval[n][n2] = dArray2[7];
                ++n2;
            }
            ++n;
        }
    }

    void initYstorage(int[] nArray, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double[][] dArray = new double[8][3];
        double[] dArray2 = new double[8];
        double d8 = d2;
        double d9 = d3;
        int n = 0;
        while (n < nArray[2] + 1) {
            d9 = d3 + d6 * (double)n;
            dArray[0] = new double[]{d, d8, d9};
            dArray[1] = new double[]{d + d4, d8, d9};
            dArray[5] = new double[]{d + d4, d8, d9 + d6};
            dArray2[0] = this.m_func2.eval(0, dArray[0]);
            dArray2[1] = this.m_func2.eval(0, dArray[1]);
            dArray2[5] = this.m_func2.eval(0, dArray[5]);
            this.yedge[n][0] = dArray2[0] < d7 != dArray2[1] < d7 ? this.addVertex(new PdVector(this.VertexInterp(d7, dArray[0], dArray[1], dArray2[0], dArray2[1]))) : -1;
            this.yedge[n][1] = dArray2[1] < d7 != dArray2[5] < d7 ? this.addVertex(new PdVector(this.VertexInterp(d7, dArray[1], dArray[5], dArray2[1], dArray2[5]))) : -1;
            this.ypoint[n] = dArray[5];
            this.yval[n] = dArray2[5];
            ++n;
        }
    }

    void initZstorage(int[] nArray, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d3;
        double[][] dArray = new double[8][3];
        double[] dArray2 = new double[8];
        dArray[1] = new double[]{d + d4, d2, d8};
        dArray[2] = new double[]{d + d4, d2 + d5, d8};
        dArray[3] = new double[]{d, d2 + d5, d8};
        dArray2[1] = this.m_func2.eval(0, dArray[1]);
        dArray2[2] = this.m_func2.eval(0, dArray[2]);
        dArray2[3] = this.m_func2.eval(0, dArray[3]);
        this.zedge[0] = dArray2[1] < d7 != dArray2[2] < d7 ? this.addVertex(new PdVector(this.VertexInterp(d7, dArray[1], dArray[2], dArray2[1], dArray2[2]))) : -1;
        this.zedge[1] = dArray2[2] < d7 != dArray2[3] < d7 ? this.addVertex(new PdVector(this.VertexInterp(d7, dArray[2], dArray[3], dArray2[2], dArray2[3]))) : -1;
        this.zpoint = dArray[2];
        this.zval = dArray2[2];
    }

    public void setEqn(String string) {
        int n = string.indexOf("=");
        String string2 = string.substring(0, n) + "- (" + string.substring(n + 1) + ")";
        if (!this.m_func2.getExpression(0).equals(string2)) {
            this.m_func2.setExpression(0, string2);
            this.update((Object)this);
        }
    }

    public double[] convertToXYZ(double[] dArray) {
        if (this.coords == 4) {
            return dArray;
        }
        if (this.coords == 7) {
            double[] dArray2 = new double[]{dArray[0] * Math.cos(dArray[1]), dArray[0] * Math.sin(dArray[1]), dArray[2]};
            return dArray2;
        }
        if (this.coords == 8) {
            double[] dArray3 = new double[]{dArray[0] * Math.sin(dArray[2]) * Math.cos(dArray[1]), dArray[0] * Math.sin(dArray[2]) * Math.sin(dArray[1]), dArray[0] * Math.cos(dArray[2])};
            return dArray3;
        }
        return dArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

