/*
 * Decompiled with CFR 0.152.
 */
package Grapher.Viewer;

import Grapher.Viewer.PjViewer;
import Grapher.util.ImageSelection;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsSlotLayout;
import jv.objectGui.PsTabPanel;
import jv.project.PgGeometry;
import jv.project.PjProject_IP;
import jv.project.PvDisplayIf;
import jv.viewer.PvDisplay;

public class PjViewer_IP
extends PjProject_IP
implements ItemListener,
ActionListener {
    public static final int TYPE_FUNC = 1;
    public static final int TYPE_PSURF = 2;
    public static final int TYPE_PCURVE = 3;
    public static final int TYPE_IMPSURF = 4;
    public static final int TYPE_VF = 5;
    public static final int TYPE_VFOS = 6;
    public static final int TYPE_IMPCYL = 7;
    public static final int TYPE_IMPSPH = 8;
    protected PjViewer m_PjViewer;
    protected Choice m_selector;
    protected Choice m_cNew;
    protected Checkbox m_cClip;
    protected Checkbox m_cShowFrame;
    protected Checkbox m_cShowAxes;
    protected boolean m_bCanUseClipboard = false;
    protected PsTabPanel m_tabpanel;
    protected PsPanel m_pMain;
    protected PsPanel m_pSel;
    protected PsPanel cps;
    protected PsPanel cp;
    protected PsPanel m_pBnds;
    protected Button m_bZoomFit;
    protected Button m_bRemove;
    protected Button m_bToClipboard;
    protected Button m_bGetClip;
    protected Checkbox m_bSclAxes;
    protected Button m_bSetCenter;
    protected String[] m_typenames = new String[]{"Choose a graph to add", "Parametric Curve", "Parametric Surface", "z=f(x,y) Surface", "Implicit Surface", "Implicit Cylindrical", "Implicit Spherical", "Vector Field", "Vector Field on Selected"};
    protected int[] m_typetable = new int[]{0, 3, 2, 1, 4, 7, 8, 5, 6};
    protected String[] m_typeshortnames = new String[]{"None", "PCurve", "PSurf", "Func", "ImpSurf", "ImpCyl", "ImpSph", "VF", "VF on"};
    static /* synthetic */ Class class$Grapher$Viewer$PjViewer_IP;

    public PjViewer_IP() {
        if (this.getClass() == (class$Grapher$Viewer$PjViewer_IP == null ? (class$Grapher$Viewer$PjViewer_IP = PjViewer_IP.class$("Grapher.Viewer.PjViewer_IP")) : class$Grapher$Viewer$PjViewer_IP)) {
            this.init();
        }
    }

    public void init() {
        SecurityManager securityManager;
        super.init();
        this.m_tabpanel = new PsTabPanel();
        ((Container)((Object)this)).add((Component)this.m_tabpanel);
        this.m_tabpanel.init();
        this.m_pMain = new PsPanel();
        PsPanel psPanel = new PsPanel((LayoutManager)new PsSlotLayout(3));
        psPanel.add("1", new Label("New graph:"));
        this.m_cNew = new Choice();
        this.m_cNew.addItemListener(this);
        int n = 0;
        while (n < this.m_typenames.length) {
            this.m_cNew.add(this.m_typenames[n]);
            ++n;
        }
        psPanel.add("2", this.m_cNew);
        this.m_pMain.add((Component)psPanel);
        PsPanel psPanel2 = new PsPanel((LayoutManager)new PsSlotLayout(3));
        psPanel2.add("1", new Label("Select Existing:"));
        this.m_selector = new Choice();
        this.m_selector.addItemListener(this);
        psPanel2.add("2", this.m_selector);
        this.m_pMain.add((Component)psPanel2);
        this.cps = new PsPanel((LayoutManager)new GridLayout(1, 1));
        this.cps.setName("cps");
        this.cps.setVisible(true);
        this.cps.setBorderType(0);
        this.m_pMain.add((Component)this.cps);
        this.m_pBnds = new PsPanel();
        this.m_bZoomFit = new Button("Zoom Fit");
        this.m_bZoomFit.addActionListener(this);
        this.m_bRemove = new Button("Remove Selected");
        this.m_bRemove.addActionListener(this);
        try {
            securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkSystemClipboardAccess();
            }
            this.m_bCanUseClipboard = true;
            this.m_bToClipboard = new Button("Copy to Clipboard");
            this.m_bToClipboard.addActionListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        securityManager = new PsPanel();
        if (this.m_bCanUseClipboard) {
            ((Container)((Object)securityManager)).setLayout(new GridLayout(2, 2));
            ((Container)((Object)securityManager)).add(this.m_bZoomFit);
            ((Container)((Object)securityManager)).add(this.m_bRemove);
            ((Container)((Object)securityManager)).add(this.m_bToClipboard);
        } else {
            ((Container)((Object)securityManager)).setLayout(new GridLayout(1, 2));
            ((Container)((Object)securityManager)).add(this.m_bZoomFit);
            ((Container)((Object)securityManager)).add(this.m_bRemove);
        }
        this.m_pMain.add((Component)((Object)securityManager));
        this.addTitle("");
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_PjViewer = (PjViewer)psUpdateIf;
        this.m_cClip = new Checkbox("Use Clip Bounds");
        this.m_cClip.addItemListener(this);
        this.m_pBnds.add(this.m_cClip);
        this.m_cShowFrame = new Checkbox("Show XYZ Frame");
        this.m_cShowFrame.addItemListener(this);
        this.m_pBnds.add(this.m_cShowFrame);
        this.m_cShowAxes = new Checkbox("Show BoundBox and axes");
        this.m_cShowAxes.addItemListener(this);
        this.m_pBnds.add(this.m_cShowAxes);
        this.m_pBnds.add((Component)this.m_PjViewer.m_clipbounds.assureInspector("Info", "_IP"));
        this.m_bSclAxes = new Checkbox("Scale Axes to current Bounds");
        this.m_bSclAxes.addItemListener(this);
        this.m_pBnds.add(this.m_bSclAxes);
        this.m_bSetCenter = new Button("Center Camera on current Bounds");
        this.m_bSetCenter.addActionListener(this);
        this.m_pBnds.add(this.m_bSetCenter);
        this.m_tabpanel.addPanel("Graph", this.m_pMain);
        this.m_tabpanel.addPanel("Bounds", this.m_pBnds);
        this.m_tabpanel.validate();
    }

    public void changeCP(String string) {
        this.cps.removeAll();
        PgGeometry pgGeometry = (PgGeometry)this.m_PjViewer.m_graphs.get(string);
        this.cps.add((Component)pgGeometry.assureInspector("Config", "_CP"));
        ((Container)((Object)this)).validate();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        PvDisplayIf pvDisplayIf;
        if (this.m_project == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.m_selector) {
            this.changeCP(this.m_selector.getSelectedItem());
            return;
        }
        if (object == this.m_cNew) {
            String string;
            int n = this.m_cNew.getSelectedIndex();
            if (n == 0) {
                return;
            }
            boolean bl = false;
            if (this.m_typetable[n] == 6) {
                if (this.m_selector.getSelectedIndex() == -1) {
                    return;
                }
                String string2 = this.m_selector.getSelectedItem();
                string = "VF on " + string2;
                if (string2.startsWith("VF")) {
                    bl = false;
                } else {
                    this.m_PjViewer.addGraph(this.m_selector.getSelectedItem(), this.m_typetable[n]);
                    bl = true;
                }
            } else {
                string = this.m_typeshortnames[n] + Integer.toString(this.m_PjViewer.m_gDef);
                this.m_PjViewer.addGraph(string, this.m_typetable[n]);
                bl = true;
            }
            if (bl) {
                int n2 = this.m_selector.getItemCount();
                this.m_selector.add(string);
                this.m_selector.select(n2);
                this.changeCP(string);
            }
            this.m_cNew.select(0);
            return;
        }
        if (object == this.m_bSclAxes) {
            if (this.m_bSclAxes.getState()) {
                this.m_PjViewer.setScl();
                this.m_PjViewer.fitDisplays();
                this.m_PjViewer.update((Object)this.m_PjViewer);
            } else {
                this.m_PjViewer.unsetScl();
            }
        }
        if (object == this.m_cClip) {
            this.m_PjViewer.setClip(this.m_cClip.getState());
        }
        if (object == this.m_cShowFrame) {
            if (this.m_cShowFrame.getState()) {
                pvDisplayIf = this.m_PjViewer.getDisplay();
                pvDisplayIf.showFrame(true);
            } else {
                pvDisplayIf = this.m_PjViewer.getDisplay();
                pvDisplayIf.showFrame(false);
            }
        }
        if (object == this.m_cShowAxes) {
            pvDisplayIf = this.m_PjViewer.getDisplay();
            if (this.m_cShowAxes.getState()) {
                pvDisplayIf.showAxes(true);
                pvDisplayIf.showBndBox(true);
                ((PvDisplay)pvDisplayIf).getAxes().setMode(2);
                ((PvDisplay)pvDisplayIf).getAxes().update((Object)((PvDisplay)pvDisplayIf).getAxes());
            } else {
                pvDisplayIf.showAxes(false);
                pvDisplayIf.showBndBox(false);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_bZoomFit) {
            this.m_PjViewer.fitDisplays();
            this.m_PjViewer.update((Object)this.m_PjViewer);
        }
        if (object == this.m_bRemove && this.m_selector.getItemCount() > 0) {
            boolean bl = this.m_PjViewer.removeGraph(this.m_selector.getSelectedItem());
            if (bl) {
                this.m_selector.remove("VF on " + this.m_selector.getSelectedItem());
            }
            this.m_selector.remove(this.m_selector.getSelectedIndex());
            if (this.m_selector.getItemCount() > 0) {
                this.m_selector.select(0);
                this.changeCP(this.m_selector.getSelectedItem());
            } else {
                this.cps.removeAll();
            }
        }
        if (object == this.m_bGetClip) {
            // empty if block
        }
        if (object == this.m_bToClipboard) {
            PvDisplayIf pvDisplayIf = this.m_PjViewer.getDisplay();
            ImageSelection imageSelection = new ImageSelection(pvDisplayIf.getImage());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(imageSelection, null);
        }
        if (object == this.m_bSetCenter) {
            this.m_PjViewer.fitDisplays();
            this.m_PjViewer.update((Object)this.m_PjViewer);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

