/*
 * Decompiled with CFR 0.152.
 */
package Grapher.Viewer;

import Grapher.geom.PgGraph;
import Grapher.geom.PgImpSurf;
import Grapher.geom.PgPCurve;
import Grapher.geom.PgPSurf;
import Grapher.geom.PgVecFld;
import Grapher.geom.PgVecFldOn;
import Grapher.util.PuDomain;
import java.awt.Color;
import java.util.Hashtable;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;

public class PjViewer
extends PjProject {
    public static final int TYPE_FUNC = 1;
    public static final int TYPE_PSURF = 2;
    public static final int TYPE_PCURVE = 3;
    public static final int TYPE_IMPSURF = 4;
    public static final int TYPE_VF = 5;
    public static final int TYPE_VFOS = 6;
    public static final int TYPE_IMPCYL = 7;
    public static final int TYPE_IMPSPH = 8;
    protected Hashtable m_graphs = new Hashtable();
    protected PuDomain m_clipbounds;
    protected int m_gDef = 1;
    static /* synthetic */ Class class$Grapher$Viewer$PjViewer;

    public PjViewer() {
        super("Parametrized Surface");
        if (((Object)((Object)this)).getClass() == (class$Grapher$Viewer$PjViewer == null ? (class$Grapher$Viewer$PjViewer = PjViewer.class$("Grapher.Viewer.PjViewer")) : class$Grapher$Viewer$PjViewer)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_clipbounds = new PuDomain();
        this.m_clipbounds.setVars(new String[]{"x", "y", "z"});
        this.m_clipbounds.setDefBnds(new double[]{-1000.0, 1000.0, 1.0, 5.0});
        this.m_clipbounds.setDefVals(new double[]{-5.0, 5.0});
        this.m_clipbounds.setNumDiscr(0);
        this.m_clipbounds.init();
        this.m_clipbounds.setParent((PsUpdateIf)this);
    }

    public void start() {
        super.start();
        PvDisplayIf pvDisplayIf = this.getDisplay();
        pvDisplayIf.setBackgroundColor(Color.white);
        int n = 0;
        while (n < 3) {
            pvDisplayIf.setClipBounds(n, new double[]{this.m_clipbounds.getMin(n), this.m_clipbounds.getMax(n)});
            ++n;
        }
    }

    public boolean update(Object object) {
        if (object == this) {
            return super.update((Object)this);
        }
        if (object == this.m_clipbounds) {
            this.updateClip();
            return true;
        }
        return super.update(object);
    }

    public boolean addGraph(String string, int n) {
        switch (n) {
            case 1: {
                PgGraph pgGraph = new PgGraph(string);
                this.m_graphs.put(string, pgGraph);
                this.addGeometry((PgGeometryIf)pgGraph);
                this.selectGeometry((PgGeometryIf)pgGraph);
                ++this.m_gDef;
                return true;
            }
            case 2: {
                PgPSurf pgPSurf = new PgPSurf(string);
                this.m_graphs.put(string, pgPSurf);
                this.addGeometry((PgGeometryIf)pgPSurf);
                this.selectGeometry((PgGeometryIf)pgPSurf);
                ++this.m_gDef;
                return true;
            }
            case 3: {
                PgPCurve pgPCurve = new PgPCurve(string);
                this.m_graphs.put(string, pgPCurve);
                this.addGeometry((PgGeometryIf)pgPCurve);
                this.selectGeometry((PgGeometryIf)pgPCurve);
                ++this.m_gDef;
                return true;
            }
            case 4: {
                PgImpSurf pgImpSurf = new PgImpSurf(string, 4);
                this.m_graphs.put(string, pgImpSurf);
                this.addGeometry((PgGeometryIf)pgImpSurf);
                this.selectGeometry((PgGeometryIf)pgImpSurf);
                ++this.m_gDef;
                return true;
            }
            case 7: {
                PgImpSurf pgImpSurf = new PgImpSurf(string, 7);
                this.m_graphs.put(string, pgImpSurf);
                this.addGeometry((PgGeometryIf)pgImpSurf);
                this.selectGeometry((PgGeometryIf)pgImpSurf);
                ++this.m_gDef;
                return true;
            }
            case 8: {
                PgImpSurf pgImpSurf = new PgImpSurf(string, 8);
                this.m_graphs.put(string, pgImpSurf);
                this.addGeometry((PgGeometryIf)pgImpSurf);
                this.selectGeometry((PgGeometryIf)pgImpSurf);
                ++this.m_gDef;
                return true;
            }
            case 5: {
                PgVecFld pgVecFld = new PgVecFld(string);
                this.m_graphs.put(string, pgVecFld);
                this.addGeometry((PgGeometryIf)pgVecFld);
                this.selectGeometry((PgGeometryIf)pgVecFld);
                ++this.m_gDef;
                return true;
            }
            case 6: {
                PgVecFldOn pgVecFldOn = new PgVecFldOn("VF on " + string);
                PgPointSet pgPointSet = (PgPointSet)this.m_graphs.get(string);
                pgVecFldOn.setGeometry(pgPointSet);
                pgPointSet.addVectorField((PgVectorField)pgVecFldOn);
                pgVecFldOn.update((Object)pgVecFldOn);
                this.m_graphs.put("VF on " + string, pgVecFldOn);
                return true;
            }
        }
        return false;
    }

    public boolean removeGraph(String string) {
        boolean bl = false;
        if (string.startsWith("VF on ")) {
            String string2 = string.substring(6);
            PgPointSet pgPointSet = (PgPointSet)this.m_graphs.get(string2);
            pgPointSet.removeAllVectorFields();
            pgPointSet.update((Object)pgPointSet);
        } else {
            PgPointSet pgPointSet = (PgPointSet)this.m_graphs.get(string);
            this.removeGeometry((PgGeometryIf)pgPointSet);
        }
        if (this.m_graphs.containsKey("VF on " + string)) {
            this.m_graphs.remove("VF on " + string);
            bl = true;
        }
        this.m_graphs.remove(string);
        return bl;
    }

    public void setScl() {
        PvDisplayIf pvDisplayIf = this.getDisplay();
        pvDisplayIf.setEnabledBoxRatio(true);
        double d = this.m_clipbounds.getMax(0) - this.m_clipbounds.getMin(0);
        double d2 = this.m_clipbounds.getMax(1) - this.m_clipbounds.getMin(1);
        double d3 = this.m_clipbounds.getMax(2) - this.m_clipbounds.getMin(2);
        double d4 = Math.min(d, Math.min(d2, d3));
        PdVector pdVector = new PdVector(d4 / d, d4 / d2, d4 / d3);
        pvDisplayIf.setBoxRatio(pdVector);
        this.update((Object)this);
        pvDisplayIf.update((Object)pvDisplayIf);
    }

    public void unsetScl() {
        PvDisplayIf pvDisplayIf = this.getDisplay();
        pvDisplayIf.setEnabledBoxRatio(false);
        pvDisplayIf.update((Object)pvDisplayIf);
    }

    public void updateClip() {
        PvDisplayIf pvDisplayIf = this.getDisplay();
        int n = 0;
        while (n < 3) {
            pvDisplayIf.setClipBounds(n, new double[]{this.m_clipbounds.getMin(n), this.m_clipbounds.getMax(n)});
            ++n;
        }
        if (pvDisplayIf.isEnabledBoxRatio()) {
            this.setScl();
        }
        this.fitDisplays();
        pvDisplayIf.update((Object)pvDisplayIf);
    }

    public void setClip(boolean bl) {
        if (bl) {
            PvDisplayIf pvDisplayIf = this.getDisplay();
            pvDisplayIf.setEnabledClipBounds(true);
            this.fitDisplays();
            pvDisplayIf.update((Object)pvDisplayIf);
        } else {
            PvDisplayIf pvDisplayIf = this.getDisplay();
            pvDisplayIf.setEnabledClipBounds(false);
            this.fitDisplays();
            pvDisplayIf.update((Object)pvDisplayIf);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

